#include "MTPNTAViewer.h"
#include "MTUtilities.h"
#include "MTExceptions.h"

MTInfoWindowDataTemplate	MTPNTAViewer::kPNTATemplate =
{
	4,
	{
		{	"ID" },
		{	"Version" },
		{	"Unknown" },
		{	"Unknown" }
	}
};

struct PNTAEntry
{
	UInt32	x;
	UInt32	y;
	UInt32	z;
};

struct MTPNTAFormat
{
	UInt32		id;
	UInt32		version;
	UInt16		filler1[6];
	UInt32		unknown1;
	UInt32		unknown2;
	PNTAEntry	entries[0];
};

void MTPNTAViewer::ParseData(UInt8 * buf, UInt32 bufSize)
{
	MTPNTAFormat	* format;
	char			text[256];
	UInt32			numEntries;
	
	if(bufSize < sizeof(MTPNTAFormat))
		throw MTUnsupportedException("Unsupported data structure");
	
	numEntries = (bufSize - 0x1C) / 12;
	
	format = (MTPNTAFormat *)buf;
	
	SWAP32(format->id);
	SWAP32(format->version);
	SWAP32(format->unknown1);
	SWAP32(format->unknown2);
	
	for(UInt32 i = 0; i < numEntries; i++)
	{
		SWAP32(format->entries[i].x);
		SWAP32(format->entries[i].y);
		SWAP32(format->entries[i].z);
	}
	
	id =						format->id;
	version =					format->version;
	*((UInt32 *)&unknown1) =	format->unknown1;
	*((UInt32 *)&unknown2) =	format->unknown2;
	
	for(UInt32 i = 0; i < numEntries; i++)
	{
		PNTAParsedEntry	entry;
		
		*((UInt32 *)&entry.x) = format->entries[i].x;
		*((UInt32 *)&entry.y) = format->entries[i].y;
		*((UInt32 *)&entry.z) = format->entries[i].z;
		
		if(	(format->entries[i].x != 0xDEADDEAD) &&
			(format->entries[i].y != 0xDEADDEAD) &&
			(format->entries[i].z != 0xDEADDEAD))
			entries.push_back(entry);
	}
	
	AttachDataTemplate(&kPNTATemplate);
	
	SetNumEntries(4 + entries.size());
	
	std::sprintf(text, "%.8X", id);
	SetEntryData(0, text, 0);
	
	std::sprintf(text, "%.8X", version);
	SetEntryData(1, text, 0);
	
	std::sprintf(text, "%+f", unknown1);
	SetEntryData(2, text, 0);
	
	std::sprintf(text, "%+f", unknown2);
	SetEntryData(3, text, 0);
	
	for(UInt32 i = 0; i < entries.size(); i++)
	{
		{
			#if 1
			
			float	* a, * b, *c;
			double	aa, bb, cc;
			
			a = (float *)&entries[i].x;
			b = (float *)&entries[i].y;
			c = (float *)&entries[i].z;
			aa = *a;
			bb = *b;
			cc = *c;
			
			std::sprintf(text,	"%+f %+f %+f",
								aa,
								bb,
								cc);
			
			#else
			
			std::sprintf(text,	"%+f %+f %+f",
								entries[i].x,
								entries[i].y,
								entries[i].z);
			
			#endif
		}
		
		SetEntryData(4 + i, text, 0);
		
		std::sprintf(text, "%.4X", i);
		SetEntryTitle(4 + i, text, 0);
	}
	
	SetOwnerName("PNTA");
	
	DisposePtr((Ptr)buf);
}